#SI considerino i seguenti dati
#Modello Marca Anno-Produzione Prezzo
#N56     Acer     2021          800
#A76     Asus     2021          970
#L78     Asus     2022          1050

#Modello  Anno VenditeUnita
#N56      2021   700
#N56      2022   1800
#A76      2021   128
#A76      2022   15
#L78      2021   87
#L78      2022   178


#Scrivere un programma che data un'azienda e un anno restituisca il fatturato dell'azienda per quell'anno
def fatturatoAziendaAnno(diz1,diz2,azienda,anno):
    risultato=0
    for prodotto in diz1:
        for vendita in diz2:
            if prodotto["Marca"] == azienda and prodotto["Modello"] == vendita["Modello"] and vendita["Anno"]==anno:
                risultato+= vendita["VenditeUnita"] * prodotto["Prezzo"]
    return risultato

#Scrivere un programma che  restituisca il fatturato annuo di ogni azienda

#Aggiorno il fatturato di ogni azienda
def aggiornaFatturato(listafatturato, marca, anno, valore):
    indice=0
    while indice < len(listafatturato):
        if listafatturato[indice]["Marca"] == marca and listafatturato[indice]["Anno"]==anno:
           listafatturato[indice]["Fatturato"]+=valore
           break
        indice+=1
    if indice == len(listafatturato):
        listafatturato.append({"Marca": marca, "Anno":anno, "Fatturato": valore})

def fatturatoTutti(diz1, diz2):
    listaFatturato=[]
    for prodotto in diz1:
        for vendita in diz2:
             if prodotto["Modello"] == vendita["Modello"]:
                  aggiornaFatturato(listaFatturato, prodotto["Marca"], vendita["Anno"], prodotto["Prezzo"]*vendita["VenditeUnita"])
    return listaFatturato

dizionario1=[{"Modello":"N56","Marca":"Acer","Anno-Produzione":"2021","Prezzo":800},
             {"Modello":"A76","Marca":"Asus","Anno-Produzione":"2021","Prezzo":970},
             {"Modello":"L78","Marca":"Asus","Anno-Produzione":"2020","Prezzo":1050}]

dizionario2=[{"Modello":"N56","Anno":"2021","VenditeUnita":700},
             {"Modello":"N56","Anno":"2022","VenditeUnita":1800},
             {"Modello":"A76","Anno":"2021","VenditeUnita":128},
             {"Modello":"A76","Anno":"2022","VenditeUnita":15},
             {"Modello":"L78","Anno":"2021","VenditeUnita":87},
             {"Modello":"L78","Anno":"2022","VenditeUnita":178}]

print("Primo esercizio:")
print(fatturatoAziendaAnno(dizionario1,dizionario2,"Acer","2021"))
print("Secondo esercizio:")
print(fatturatoTutti(dizionario1,dizionario2))